/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.soap.util;

import filenet.pe.sso.CookieManager;
import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import filenet.vw.soap.transport.VWSOAPHTTPConnection;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Vector;
import org.apache.soap.Fault;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.encoding.soapenc.Base64;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.Response;
import org.apache.soap.transport.SOAPTransport;

public class VWSOAPUtils {
    private static Logger logger = Logger.getLogger("filenet.vw.soap");
    private static final String m_className = "VWSOAPUtils";
    private static HashMap m_HttpConnections = new HashMap();
    private static final int FNOBJ_BEGIN = 11111;
    private static final int FNOBJ_END = 22222;

    private static VWSOAPHTTPConnection getVWSOAPHttpConnection(String serverURL, String creds, String sessionId) {
        String key = serverURL + "_" + creds + "_" + sessionId;
        VWSOAPHTTPConnection c = (VWSOAPHTTPConnection)((Object)m_HttpConnections.get(key));
        if (c == null) {
            c = new VWSOAPHTTPConnection(creds, sessionId);
            m_HttpConnections.put(key, c);
            if (logger.isFinest()) {
                logger.finest(m_className, "getVWSOAPHttpConnection", "creating a new one.");
            }
        } else if (logger.isFinest()) {
            logger.finest(m_className, "getVWSOAPHttpConnection", "reuse");
        }
        return c;
    }

    public static Object invoke(String serverURL, String methodName, String[] paramNames, Object[] paramValues, Class[] paramClasses, String creds, String sessionId) throws VWException {
        Response resp;
        String m_method;
        block17: {
            Object msg;
            m_method = "invoke:" + methodName + ", serverURL=" + serverURL + ", sessionId=" + sessionId;
            logger.entering(m_className, m_method);
            SOAPMappingRegistry smr = new SOAPMappingRegistry();
            Call call = new Call();
            call.setSOAPMappingRegistry(smr);
            call.setTargetObjectURI("urn:filenet-vw-soap-router");
            call.setEncodingStyleURI("http://schemas.xmlsoap.org/soap/encoding/");
            VWSOAPHTTPConnection conn = VWSOAPUtils.getVWSOAPHttpConnection(serverURL, creds, sessionId);
            call.setSOAPTransport((SOAPTransport)conn);
            resp = null;
            call.setMethodName(methodName);
            if (paramNames != null) {
                int paramCount = paramNames.length;
                Vector<Parameter> params = new Vector<Parameter>(paramCount);
                for (int i = 0; i < paramCount; ++i) {
                    params.addElement(new Parameter(paramNames[i], paramClasses[i], paramValues[i], null));
                }
                call.setParams(params);
            } else {
                call.setParams(null);
            }
            URL sURL = new URL(serverURL);
            boolean tryAgain = false;
            while (true) {
                try {
                    resp = call.invoke(sURL, "");
                }
                catch (SOAPException ex) {
                    msg = ex.getMessage();
                    if (((String)msg).indexOf("AUTOSUBMIT") != -1) {
                        Thread.sleep(100L);
                        sessionId = CookieManager.checkSMCookies(sessionId, sURL, null);
                        conn.setSessionId(sessionId);
                        if (logger.isFinest()) {
                            logger.finest(m_className, m_method, "GOT NEW COOKIE, RETRYING CALL, Got: " + (String)msg);
                        }
                    } else {
                        if (((String)msg).indexOf("Unsupported response content type \"text/html;") != -1) {
                            throw new VWException("vw.soap.util.VWSOAPUtils.invoke.sessionTimeout", "Unexpected response from server.  Perhaps a session timeout has been encountered.  Please save your work locally and restart the browser session.");
                        }
                        throw new VWException(ex);
                    }
                    tryAgain = true;
                    if (tryAgain) continue;
                }
                break;
            }
            if (resp.generatedFault()) break block17;
            Parameter sRet = resp.getReturnValue();
            msg = sRet.getValue();
            Object var18_23 = null;
            logger.exiting(m_className, m_method);
            return msg;
        }
        try {
            try {
                Fault fault = resp.getFault();
                String faultString = fault.getFaultString();
                Object obj = VWSOAPUtils.base64ObjectDeserializer(faultString);
                if (obj != null && obj instanceof Throwable) {
                    logger.severe(m_className, m_method, "Got Exception:" + obj.getClass().getName() + ",msg=" + obj.toString());
                    throw (Throwable)obj;
                }
                logger.severe(m_className, m_method, "Fault=" + faultString);
                throw new Exception(faultString);
            }
            catch (VWException vwe) {
                throw vwe;
            }
            catch (Throwable t) {
                throw new VWException(t);
            }
        }
        catch (Throwable throwable) {
            Object var18_24 = null;
            logger.exiting(m_className, m_method);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String base64ObjectSerializer(Object obj) {
        String m_method = "base64ObjectSerializer";
        String res = null;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ObjectOutputStream p = null;
        try {
            p = new ObjectOutputStream(stream);
            p.writeInt(11111);
            p.writeObject(obj);
            p.writeInt(22222);
            p.flush();
            byte[] bytes = stream.toByteArray();
            res = Base64.encode((byte[])bytes);
            return res;
        }
        catch (Throwable throwable) {
            Exception e2;
            Object var7_9 = null;
            if (p != null) {
                try {
                    p.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Object base64ObjectDeserializer(String src) {
        Object res;
        block28: {
            Exception e2222;
            ObjectInputStream p;
            ByteArrayInputStream stream;
            block22: {
                block23: {
                    Exception e2222;
                    Object object;
                    block24: {
                        String m_method = "base64ObjectDeserializer";
                        res = null;
                        stream = null;
                        p = null;
                        byte[] bytes = Base64.decode((String)src);
                        stream = new ByteArrayInputStream(bytes);
                        p = new ObjectInputStream(stream);
                        int i = p.readInt();
                        if (i != 11111) break block22;
                        res = p.readObject();
                        i = p.readInt();
                        if (i != 22222) break block23;
                        object = res;
                        Object var9_9 = null;
                        if (p == null) break block24;
                        try {
                            p.close();
                        }
                        catch (Exception e2222) {
                            // empty catch block
                        }
                    }
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Exception e2222) {
                            // empty catch block
                        }
                    }
                    return object;
                }
                try {
                    res = null;
                }
                catch (Throwable throwable) {
                    Exception e2222;
                    Object var9_12 = null;
                    if (p != null) {
                        try {
                            p.close();
                        }
                        catch (Exception e2222) {
                            // empty catch block
                        }
                    }
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Exception e2222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            Object var9_10 = null;
            if (p != null) {
                try {
                    p.close();
                }
                catch (Exception e2222) {
                    // empty catch block
                }
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e2222) {}
            }
            break block28;
            {
                catch (Exception e3) {
                    Exception e2222;
                    Object var9_11 = null;
                    if (p != null) {
                        try {
                            p.close();
                        }
                        catch (Exception e2222) {
                            // empty catch block
                        }
                    }
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Exception e2222) {}
                    }
                }
            }
        }
        return res;
    }
}

